package com.vmware.samples.chassisui.views.wizardPages {

import com.vmware.samples.chassisui.model.ChassisInfo;
import com.vmware.widgets.controls.wizardclasses.PageInfo;
import com.vmware.widgets.controls.wizardclasses.PageState;
import com.vmware.widgets.controls.wizardclasses.WizardPageMediator;

/**
 * The mediator for the SummaryPage view. It extends the WizardPageMediator which gives it
 * the needed functions to easily integrate with the ChassisWizard.
 *
 */
public class SummaryPageMediator extends WizardPageMediator {

   // The view that this mediator controls.
   private var _view:SummaryPage;
   private var _pageInfo:PageInfo;

   [InjectableView]
   /**
    * The view associated with this mediator.
    */
   public function set view(value:SummaryPage):void {
      _view = value;
   }

   /** @private */
   public function get view():SummaryPage {
      return _view;
   }

   /**
    * ChassisInfo data model inherited from the wizard.
    */
   private var _data:ChassisInfo;

   [Inherited]
   public function set data(value:ChassisInfo):void {
      if (_data != value) {
         _data = value;
      }
      if (_view != null && value != null) {
         // initialize text fields
         _view.chassisInfo = value;
      }
   }

   /** @private */
   public function get data():ChassisInfo {
      return _data;
   }

   /**
    * The last page doesn't need any commitFunction, once it is reached the Finish
    * button should alway be enabled.
    */
   override public function activate():void {
      this.pageInfo.initialized = true;
      changeState(PageState.COMPLETE);
   }
}
}